# Variables
$certName = "PnPAppOnlyCert"
$certPath = "C:\temp\PnPAppOnlyCert.pfx"
$duration = (Get-Date).AddMonths(1)
$pwd = Read-Host -AsSecureString "Enter Cert Password"

# Create self-signed cert in CurrentUser\My store
$cert = New-SelfSignedCertificate `
    -Subject "CN=$certName" `
    -CertStoreLocation "Cert:\CurrentUser\My" `
    -KeyExportPolicy Exportable `
    -KeySpec Signature `
    -KeyLength 2048 `
    -NotAfter $duration

# Export to PFX
Export-PfxCertificate `
    -Cert $cert `
    -FilePath $certPath `
    -Password $pwd

Write-Host "Certificate created and exported to $certPath"
Write-Host "Thumbprint: $($cert.Thumbprint)"

Export-Certificate -Cert $cert -FilePath "C:\temp\$certName.cer"